﻿#include "precompiled.h"
#include "common.h"
#include "DepthStencil.h"

// For depth stencil, use TYPELESS instead of DXGI_FORMAT_D24_UNORM_S8_UINT
// to allow reading as a shader resource.
const auto dsTexFormat = DXGI_FORMAT_R24G8_TYPELESS;
const auto dsSrvFormat = DXGI_FORMAT_R24_UNORM_X8_TYPELESS;

const auto dsViewFormat = DXGI_FORMAT_D24_UNORM_S8_UINT;
// Allow reading from the depth stencil
const int dsBindFlags = D3D11_BIND_DEPTH_STENCIL | D3D11_BIND_SHADER_RESOURCE;

namespace RTCam {

DepthStencil::DepthStencil(_In_z_ const char* name) :
	Texture(name),
	m_depthStencilView(nullptr)
{
}

DepthStencil::~DepthStencil(void)
{
}

void DepthStencil::Init(_In_ ID3D11Device1* device, size_t width, size_t height)
{
	Texture::InitTexture(device, width, height, dsTexFormat, dsSrvFormat, dsBindFlags, false);

	// Create the depth stencil view
	CD3D11_DEPTH_STENCIL_VIEW_DESC dsvDesc(
		D3D11_DSV_DIMENSION_TEXTURE2D,
		dsViewFormat
		);

	ThrowIfFailed(
		device->CreateDepthStencilView(
		m_texture.Get(),
		&dsvDesc,
		&m_depthStencilView
		)
		);

	SetDebugObjectName(m_depthStencilView.Get(), m_name + "View");
}

void DepthStencil::ReleaseResources()
{
	m_depthStencilView = nullptr;

	Texture::ReleaseResources();
}

} // end namespace